﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class RegistrantRetirementImporter : AHOBPRBaseBO, IEmisImporter, IRegistrantUpdater
    {
        eMISMilitaryInformationSerivcePortTypesClient _client;
        #region constructors
        public RegistrantRetirementImporter()
        {          
            _client = new eMISMilitaryInformationSerivcePortTypesClient();
            InputHeaderInfo = new InputHeaderInfo();
        }
        #endregion
        #region Properties
        public InputHeaderInfo InputHeaderInfo
        {
            get;
            set;
        }
        public string Name { get { return "Retirement"; } }
        #endregion


        public void GetEmisInfoForRegistrant(string edipi, string ssn, IRegistrantManager registrantManager)
        {
            //use the AHOBPRRegistrantManager to get info from DB on the Registrant
            if (registrantManager == null) { registrantManager = new AHOBPRRegistrantManager(); }

            REGISTRANT registrant = registrantManager.GetRegistrantById(edipi, ssn);
            if (registrant.EDIPI == edipi)
            {
                UpdateRetirementData(edipi, registrant.REGISTRANT_ID);
            }
            else
            {
                throw new NotImplementedException("Implement logic to log AHOBPR.REGISTRANT db entry's EDIPI not matching with Registrant's edipi");
            }
        }

        public bool Update(string edipi, int registrantId)
        {
            return UpdateRetirementData(edipi, registrantId);  
        }

        public void GetEmisInfoForRegistrant(REGISTRANT registrant)
        {
            List<Retirement> retirementData = GetRetirementData(registrant.EDIPI);
            ProcessRetirementResponse(retirementData, registrant.REGISTRANT_ID);
        }

        void ProcessRetirementResponse(List<Retirement> retirementData, int registrantId)
        {
            if (retirementData != null && retirementData.Count > 0)
            {
                var dbEntries = new List<REGISTRANT_RETIREMENT>();
                foreach (Retirement entry in retirementData)
                {
                    var data = entry.retirementData;
                    var newEntry = new REGISTRANT_RETIREMENT(data, registrantId);
                    //make sure the newEntry at least has a beginDate and a typecode
                    if (newEntry.RETIREMENT_BEGIN_DATE != DateTime.Parse("01-01-0001") && newEntry.STD_RETIREMENT_TYPE_ID != null)
                    {
                        dbEntries.Add(newEntry);
                    }
                }
                //Don't delete any existing registrant retirement entries unless we have new data 
                //to replace it with
                if (dbEntries.Count >= 1)
                {
                    DeleteExistingRegistrantRetirementEntries(registrantId);
                    AddRegistrantRetirementEntriesToDb(dbEntries);
                }
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="edipi"></param>
        /// <param name="registrantId"></param>
        bool UpdateRetirementData(string edipi, int registrantId)
        {
            var result = true;
            try
            {
                List<Retirement> retirementData = GetRetirementData(edipi);
                if (retirementData != null && retirementData.Count > 0)
                {
                    var dbEntries = new List<REGISTRANT_RETIREMENT>();
                    foreach (Retirement entry in retirementData)
                    {
                        var data = entry.retirementData;
                        var newEntry = new REGISTRANT_RETIREMENT(data, registrantId);
                        //make sure the newEntry at least has a beginDate and a typecode
                        if (newEntry.RETIREMENT_BEGIN_DATE != DateTime.Parse("01-01-0001") && newEntry.STD_RETIREMENT_TYPE_ID != null)
                        {
                            dbEntries.Add(newEntry);
                        }
                    }
                    //Don't delete any existing registrant retirement entries unless we have new data 
                    //to replace it with
                    if (dbEntries.Count >= 1)
                    {
                        DeleteExistingRegistrantRetirementEntries(registrantId);
                        AddRegistrantRetirementEntriesToDb(dbEntries);
                    }
                }
            }
            catch (Exception ex)
            {
                AHOBPRLogger.LogErrorMessage("Exception", this.GetType().Name + "." + System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message + "; " + ex.StackTrace);
                result = false;
            }

            return result;
        }

        //TODO: Get Metrics on this
        static void AddRegistrantRetirementEntriesToDb(List<REGISTRANT_RETIREMENT> dbEntries)
        {
            if (dbEntries != null && dbEntries.Count >= 1)
            {
                using (_dbAhobpr = GetDataContext())
                {
                    _dbAhobpr.REGISTRANT_RETIREMENTs.InsertAllOnSubmit(dbEntries);
                    _dbAhobpr.SubmitChanges();
                }
            }
        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="registrantId"></param>
        static void DeleteExistingRegistrantRetirementEntries(int registrantId)
        {
            var registrantDBRetirementEntries = new List<REGISTRANT_RETIREMENT>();
            using (_dbAhobpr = GetDataContext())
            {
                registrantDBRetirementEntries = _dbAhobpr.REGISTRANT_RETIREMENTs.Where(e => e.REGISTRANT_ID == registrantId).ToList();
                _dbAhobpr.REGISTRANT_RETIREMENTs.DeleteAllOnSubmit(registrantDBRetirementEntries);
                _dbAhobpr.SubmitChanges();
            }

        }
        List<Retirement> GetRetirementData(string edipi)
        {
            eMISretirementResponseType response = GetRetirementResponse(edipi);
            if (response.retirement != null)
            {
                return response.retirement.ToList<Retirement>();
            }
            return new List<Retirement>();
        }
        public eMISretirementResponseType GetRetirementResponse(inputEdiPiOrIcn edipi, InputHeaderInfo headerInfo)
        {
            eMISretirementResponseType retirementResponse = null;
            try
            {
                retirementResponse = _client.getRetirement(ref headerInfo, edipi);
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Exception: RegistrantRetirementImporter.GetRetirementResponse: " + ex.Message + "\n" + ex.StackTrace);
                AHOBPRLogger.LogErrorMessage("Exception", this.GetType().Name + "." + System.Reflection.MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }
            return retirementResponse;
        }

        public eMISretirementResponseType GetRetirementResponse(string edipi)
        {
            var inputEdipiIcn = InputEdipiOrIcnCreator.Create(edipi);
            return GetRetirementResponse(inputEdipiIcn, InputHeaderInfo);
        }
    }
}
